/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.connection.FluxNetwork;

public class FluxDeviceItem
extends BlockItem {
    public FluxDeviceItem(Block block, Item.Properties props) {
        super(block, props);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String value;
        CompoundTag tag = stack.m_41737_("FluxData");
        if (tag != null && !(value = tag.m_128461_("customName")).isEmpty()) {
            return new TextComponent(value);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("FluxData");
        if (tag != null) {
            FluxNetwork network = ClientCache.getNetwork(tag.m_128451_("networkID"));
            if (network.isValid()) {
                tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + FluxTranslate.NETWORK_FULL_NAME.get() + ": " + ChatFormatting.RESET + network.getNetworkName()));
            }
            if (tag.m_128441_("limit")) {
                tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + FluxTranslate.TRANSFER_LIMIT.get() + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(tag.m_128454_("limit"))));
            }
            if (tag.m_128441_("priority")) {
                tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + FluxTranslate.PRIORITY.get() + ": " + ChatFormatting.RESET + tag.m_128451_("priority")));
            }
            if (tag.m_128441_("buffer")) {
                tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + FluxTranslate.INTERNAL_BUFFER.get() + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(tag.m_128454_("buffer"))));
            } else if (tag.m_128441_("energy")) {
                long energy = tag.m_128454_("energy");
                Block block = this.m_40614_();
                double percentage = block instanceof FluxStorageBlock ? Math.min((double)energy / (double)((FluxStorageBlock)block).getEnergyCapacity(), 1.0) : 0.0;
                tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + FluxTranslate.ENERGY_STORED.get() + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(energy) + String.format(" (%.1f%%)", percentage * 100.0)));
            }
        } else {
            super.m_7373_(stack, level, tooltip, flag);
        }
    }
}

